/**************************** Data In Parameter *******************************

 InFlag       -> The flag will be " SET " when MG84FL54BD receive data from PC
                 and stored in InBuffer[64] already.
 InLen        -> Size of data that stored in InBuffer[64]
 InBuffer[64] -> Data buffer
 KB_LED       -> Keyboard LED status , bit0 for NumLock , bit1 for Caps , bit2
                 for ScrollLock , others for reserve
 UsbEvent     -> Notice some USB events from Host ,such as " Suspend / Wakeup / 
                 Reset / EmuOK / KB_LED "
 
*******************************************************************************/
extern     BIT InFlag;
extern     BYTE InLen;
extern     XBYTE InBuffer[64];
extern     BYTE KB_LED;
extern     USBEVENT UsbEvent;

/****************************** Function Call *********************************


 Initial();                             -> Will enable USB function that include
                                           " Device Firmware Upgrade "
 USB_Send_Data_To_PC( Size , *Buffer ); -> Size   --> The maximum number of bytes 
                                                      will be send to PC.
                                           *Buffer --> A pointer to the buffer that 
                                                       content the data will be send 
                                                       to PC.
 USB_Read_Data_Complete();              -> Will release buffer for next data  
                                           transfer from PC
 USB_Send_Key_To_PC( Modifiler , Size , *Buffer );
                                        -> Modifiler --> Report the " Ctrl / Alt /
                                                         Shift " keys status to host
                                           Size   --> The maximum number of keys 
                                                      will be send to PC.
                                           *Buffer --> A pointer to the buffer that 
                                                       content the keys will be send 
                                                       to PC.
 USB_Send_MediaKey_To_PC( MediaKey );   -> MediaKey --> Report the " Vol+ / Vol- /
                                                        Mute / .." keys status to host
 USB_WakeUp_Host();                     -> Function for WakeUp host , return " SET " for
                                           wakeup successfully , otherwise for wakeup
                                           fail
                                           
*******************************************************************************/
extern     void Initial( void );
extern     void USB_Send_Data_To_PC( BYTE , BYTE * );
extern     void USB_Read_Data_Complete( void );
extern     void USB_Send_Key_To_PC( BYTE , BYTE , BYTE * );
extern     void USB_Send_MediaKey_To_PC( BYTE );
extern     BIT USB_WakeUp_Host( void );